<?php

if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

class Ultimate_AI_Chat_Assistant_Controller
{
  private $Chat_Assistant_Manager;

  public function __construct()
  {
    $this->Chat_Assistant_Manager = new Ultimate_AI_Chat_Assistant();
    add_action('wp_ajax_ultimate_ai_create_chat_assistant', [$this, 'ultimate_ai_create_chat_assistant']);
    add_action('wp_ajax_ultimate_ai_get_all_chat_assistants', [$this, 'ultimate_ai_get_all_chat_assistants']);
    add_action('wp_ajax_ultimate_ai_delete_chat_assistant', [$this, 'ultimate_ai_delete_chat_assistant']);
    add_action('wp_ajax_ultimate_ai_update_chat_assistant', [$this, 'ultimate_ai_update_chat_assistant']);
    register_activation_hook(ULTIMATE_AI_PLUGIN_ROOT . 'ultimate_ai.php', [$this, 'run_regiser_activation_methods']);
  }

  public function run_regiser_activation_methods()
  {
    $this->update_prev_assistant_meta_to_new_standard();
  }

  public function update_prev_assistant_meta_to_new_standard()
  {
    $Chat_Assistant_Manager = new Ultimate_AI_Chat_Assistant();
    if ($Chat_Assistant_Manager->is_new_version_available()) {
      $Chat_Assistant_Manager->migrate_assistant_meta_to_new_structure();
    }
  }

  public function ultimate_ai_create_chat_assistant()
  {
    $name = sanitize_text_field($_POST['name']);
    $desc = sanitize_text_field($_POST['description']);
    $prompt = sanitize_text_field($_POST['prompt']);
    $icon_url = sanitize_text_field($_POST['icon_url']);
    $id = sanitize_text_field($_POST['id']);

    $res = $this->Chat_Assistant_Manager->ultimate_ai_create_chat_assistant($name, $prompt, $desc, $icon_url, $id);

    if (!$res['is_success']) {
      wp_send_json(['data' => $res['message']], 400);
    }

    wp_send_json(['data' => $res['data']], 200);
  }

  public function ultimate_ai_get_all_chat_assistants()
  {
    $is_only_user_assistants = rest_sanitize_boolean($_POST['is_only_user_assistants']);
    $is_only_user_assistants = $is_only_user_assistants ? $is_only_user_assistants : false;

    if ($is_only_user_assistants) {
      //get all admin assistant first
      $res_one = $this->Chat_Assistant_Manager->ultimate_ai_get_chat_assistants(
        [
          "meta_query" =>
          [
            "relation" => "AND",
            ["key" => "is_admin", "value" => "yes", "compare" => "="],
            ["key" => "is_active", "value" => "yes", "compare" => "="]
          ]
        ]
      );

      //get only user assistant
      $res_two = $this->Chat_Assistant_Manager->ultimate_ai_get_chat_assistants(
        [
          "author" => (wp_get_current_user())->ID,
          "meta_query" =>
          [
            ["key" => "is_active", "value" => "yes", "compare" => "="]
          ]
        ]
      );

      //merge 2 result and remove duplicate
      $_data = array_merge($res_one["chat_assistant"], $res_two["chat_assistant"]);
      $data = [];
      foreach ($_data as $d) {
        $data[$d["id"]] = $d;
      }

      wp_send_json(['data' => ['chat_assistant' => array_values($data), 'total_chat_assistant' => count($data)]], 200);
    } else {
      //get all assistant
      $all_assistant = $this->Chat_Assistant_Manager->ultimate_ai_get_chat_assistants();

      wp_send_json(['data' => $all_assistant], 200);
    }
  }

  // ========= Delete chat assistant =========================
  public function ultimate_ai_delete_chat_assistant()
  {
    $assistant_id = (int) sanitize_text_field($_POST['id']);

    $delete_result = $this->Chat_Assistant_Manager->ultimate_ai_delete_chat_assistant($assistant_id);

    if (!$delete_result['success']) {
      wp_send_json(['data' => 'Chat assistant deletion failed. ' . $delete_result['message']], 400);
    }

    wp_send_json(['data' => 'Chat assistant deleted successfully'], 200);
  }

  // ===================== update_chat_assistant ==================
  public function ultimate_ai_update_chat_assistant()
  {
    $key_name = sanitize_key($_POST['key_name']);
    $value = sanitize_text_field($_POST['value']);
    $chat_id = (int) sanitize_text_field($_POST['chat_id']);
    $is_direct_meta = true; // hard coded for now
    $res = $this->Chat_Assistant_Manager->ultimate_ai_update_chat_assistant_meta($key_name, $value, $chat_id, $is_direct_meta);

    if (!$res['is_success']) {
      wp_send_json(['data' => $res['message']], 400);
    }

    wp_send_json(['data' => $res['data']], 200);
  }
}
new Ultimate_AI_Chat_Assistant_Controller();
